/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_FUTURE_H
#define _SCE_FUTURE_H
#include "utility_errors.h"
#include "future_impl.h"
#include "job.h"
#include <assert.h>

namespace sce {
	namespace Toolkit{
		namespace NP{
			/// @brief
			/// The namespace for utilities used by the %NP %Toolkit library.
			///
			/// The namespace for utilities used by the %NP %Toolkit library.
			namespace Utilities {

	/// @brief
	/// A template implementation of the future class.
	///
	///	This class provides the implementation of future objects for the %NP %Toolkit library.
	/// A future object is effectively "locked" until the result is ready or an error occurs.
    ///
	/// The template conforms to the same functionality as <c>FutureImpl</c>.
	/// However, it contains the pointer to data of template type T. 
	///
	/// @param T The data. This must be default constructed or an integral type. If it does not have a default constructor,
	///				a pointer type must be used instead.
	///
	/// @par Example:
	/// @code
	///	Future<int> mFuture;
	/// int ret = doLongAsyncJob(&mFuture); // result will be placed in mFuture once ready.
	/// while( !mFuture.hasError() && ! mFuture.hasResult() )
	///		mFuture.waitFor(TIMEOUT_VALUE);
	///	if(mFuture.hasError() ) 
	///		ret = mFuture.getError();
	/// else
	///		mFuture.getResult();	//will return a pointer to the data.
	/// @endcode
	template<class T> class Future : public FutureImpl 
	{
	public:
		friend class Job<T>;
		/// @brief The default constructor.
		///
		/// This will call the default constructor of class T.
		Future() : FutureImpl(),
			m_result() 
		{

		}

		/// @brief The default virtual destructor.
		///
		/// The destructor of the <c>Future</c> will also destroy the enclosed T object.
		virtual ~Future() 
		{

		}

		/*/// @brief Convenience method which combines the wait and get methods.
		///
		/// This method waits
		T*			waitAndGet()
		{
			wait(0);
			if(hasError())
				return NULL;
			else
				return get();
		}*/

		///	@brief Gets a pointer to the internal data that has been set.
		/// 
		/// Gets a pointer to the internal data that has been set.
		///
		/// @note
		/// The internal data is effectively inaccessible until it has been set.
		///
		/// @return
		/// A pointer to the encapsulated data. A <c>NULL</c> pointer is returned if the data has not been set.
		T *get()
		{
			if(!hasResult())
				return NULL;
			else
				return &m_result;
		}


		/// @brief Sets the internal data.
		///
		/// Sets the internal data. Used by the %NP %Toolkit library threads to set the data. Should be made invisible
		/// outside the library.
		///
		/// @note This method should have been made private with friend classes identified. However,
		///			due to the class being a template it would still be visible. Related to the coupling of threads
		///			to future objects.
		///
		/// @param data The data to be copied into the result object.
		//void setResult(T& data) 
		//{
		//	m_result = data;
		//	FutureImpl::resultSet();
		//}

		
	private:
		
		T	m_result;
	};

			}//end Utilities
		}//end NP
	}//end Toolkit
}//end Sce

#endif
